/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
::   Module      :   Global Type Definitions
::   Copyright   :   (C)2002-2009 Woodward
::   Platform(s) :   MPC5xx
::   Limitations :   None
::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
/*! \file typedefn.h
 \brief Global Type Definitions
*/
#ifndef __TYPEDEFN_H
#define __TYPEDEFN_H

/* --- INCLUDE FILES ----------------------------------------------------------------------------------------*/
#include <AtomicTypes.h>    /* Atomic data type definitions                                                  */

#ifdef __ghs
#include <ghs_null.h>       /* Defines NULL appropriately for the chosen compilation language [C/CPP]        */
#else
#include <stddef.h>         /* Defines NULL appropriately for the chosen compilation language [C/CPP]        */
#endif

/* --- DEFINES ----------------------------------------------------------------------------------------------*/
#define PLATFORM_WORD_SIZE 4    /* 4 Bytes contained within a single word */

/* Use ThreadSafeFree and ThreadSafeMalloc instead of malloc and free                  */
#define malloc ThreadSafeMalloc
#define free ThreadSafeFree

#ifndef TRUE
    #define TRUE        (1)
#endif

#ifndef FALSE
    #define FALSE       (0)
#endif

#if (TRUE != 1)
    #error There is a mismatch in the definition of TRUE against what is expected
#endif

#if (FALSE != 0)
    #error There is a mismatch in the definition of FALSE against what is expected
#endif

#define MIN_UINT1   0L
#define MAX_UINT1   255L

#define MIN_UINT2   0L
#define MAX_UINT2   65535L

#define MIN_UINT4   0L
#define MAX_UINT4   4294967295L

#define MIN_SINT1   -128L
#define MAX_SINT1   127L

#define MIN_SINT2   -32768L
#define MAX_SINT2   32767L

#define MIN_SINT4   -2147483648L
#define MAX_SINT4   2147483647L


#define UNUSED(a)	(a = a)

#define INLINE
/* #define INLINE      __inline */
/* This is used with calibration parameter.  If a calibration is defined as a const, the compiler would
   Use the initial value throughout the code.  If we need the calibration to be looked up every time
   then we have to define the const as a volatile const.  This forces the compiler to read the calibration 
   location every time it is used. */
#define Calconst volatile const
#define CALCONST volatile const

/* This type is used with Table lookup definition */
#define RAMVAR  volatile

/* This type is used with Table lookup definition */
#define EEVAR  volatile

/* This type is used with Table lookup definition that are placed in RAM and the user handles its load/restore */
#define ADAPTIVE_VOLATILE volatile

/* Used with Set operations */
typedef unsigned int                SetVarType_U;
typedef int                         SetVarType_S;

/* Used with Local Variables and API functions */
typedef unsigned int                NativeVar_U;
typedef int                         NativeVar_S;

/* An integer that is suitably sized to hold a pointer */
typedef uint4                       NativePtrSizedInt_U;

/* A boolean variable that uses a native integer */
typedef uint4                       NativeBool;

/* The native size of an ADC sample */
typedef uint2                       NativeADC_U;

/* Name: E_Boolean ClassID:ENUMDEC EnumDflt:"Illegal" */
typedef enum
{
    BOOLEAN_FALSE,                 /* EnumTxt:"FALSE" */
    BOOLEAN_TRUE                   /* EnumTxt:"TRUE" */
} E_Boolean;

/* --- FUNCTION PROTOTYPES ----------------------------------------------------------------------------------*/

#endif /* __TYPEDEFN_H*/

